using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using Intemi;

namespace InTreesPrg
{
    class Program
    {
        static void Main(string[] args)
        {
            Project project = null;
            try
            {
                project = new Project(new LocalTaskMgr());
                project.LoadAssembly("TutorialPrg");

                TimeSpan begin = Process.GetCurrentProcess().UserProcessorTime;
                DateTime dtB = DateTime.Now;

               
                //InTreesExpl.MultiTreeTest_CV(project);
                InTreesExpl.TreeTest_CV(project);
                InTreesExpl.TestyPorownawczeKlasyfikatorow(project);
              
                

                project.Close();

                TimeSpan end = Process.GetCurrentProcess().UserProcessorTime;
                DateTime dtE = DateTime.Now;
                Console.WriteLine("  Time consumed (proc/real): {0} s / {1} s",
                    (double)((end.Ticks - begin.Ticks) / 10000) / 1000,
                    (double)(dtE.Subtract(dtB).Ticks / 10000) / 1000);
            }
            catch (Exception e)
            {
                Console.WriteLine("Exception: " + e.Message);
                if (project != null)
                    project.Close();
            }
        }
    }

}
